VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 1  'vbSimpleBound
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CEmployee"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'*******************************************************************
' Module: CEmployee.cls
'
' The Employee class definition
'
'*******************************************************************
Option Explicit

'Keep member data as private
Private m_Name As String
Private m_SSN As String
Private m_PayRate As Double
Private m_Hours As Double
Private m_StartDate As Date

Private m_rsEmps As ADODB.Recordset

'*******************************************************************
' Employee Properties
'*******************************************************************
Public Property Let Name(NewName As String)
    m_Name = NewName
End Property
Public Property Get Name() As String
    Name = m_Name
End Property

Public Property Let SSN(sData As String)
    m_SSN = sData
End Property
Public Property Get SSN() As String
    SSN = m_SSN
End Property

Public Property Let PayRate(sData As Double)
    m_PayRate = sData
End Property
Public Property Get PayRate() As Double
    PayRate = m_PayRate
End Property

Public Property Let Hours(sData As Double)
    m_Hours = sData
End Property
Public Property Get Hours() As Double
    Hours = m_Hours
End Property

Public Property Let StartDate(dtDate As Date)
    m_StartDate = dtDate
End Property
Public Property Get StartDate() As Date
    StartDate = m_StartDate
End Property


'*******************************************************************
' Employee methods
''*******************************************************************
Public Function AsString() As String
    Dim sEmp As String
    
    sEmp = "Name: " & vbTab & m_Name & vbCrLf
    sEmp = sEmp & "ID: " & vbTab & m_SSN & vbCrLf
    sEmp = sEmp & "PayRate: " & vbTab & m_PayRate & vbCrLf
    sEmp = sEmp & "Hours: " & vbTab & m_Hours & vbCrLf
    sEmp = sEmp & "Start Date: " & Format(m_StartDate, "long date") & vbCrLf
    AsString = sEmp
End Function

Public Sub Save()
    Dim sSQl As String
    
    sSQl = "Select * from Employees where ID = '" & m_SSN & "'"
    m_rsEmps.Open sSQl
    If m_rsEmps.BOF Then
        m_rsEmps.AddNew
        m_rsEmps.Fields("ID") = m_SSN
    End If
    
    With m_rsEmps
        .Fields("Name") = m_Name
        .Fields("Hours") = m_Hours
        .Fields("PayRate") = m_PayRate
        .Fields("StartDate") = m_StartDate
    End With
    
    m_rsEmps.Update
    m_rsEmps.Close
    
End Sub

Public Sub Load(ID As String)
    Dim sSQl As String
    
    sSQl = "Select * from Employees where ID = '" & ID & "'"
    With m_rsEmps
        .Open sSQl
        If Not .BOF Then
            m_Name = .Fields("Name")
            m_SSN = .Fields("ID")
            m_PayRate = .Fields("PayRate")
            m_Hours = .Fields("Hours")
            m_StartDate = .Fields("StartDate")
        End If
        .Close
    End With

End Sub

Public Function AllAsString() As String
    Dim rs As New ADODB.Recordset
    Dim sMsg As String
    
    rs.Open "SELECT ID FROM Employees", deEmpData.cnnEmpData
    Do While Not rs.EOF
        Load rs.Fields("ID")
        sMsg = sMsg & AsString() & vbCrLf
        rs.MoveNext
    Loop
    
    rs.Close
    AllAsString = sMsg
       
End Function


Private Sub Class_Initialize()
    deEmpData.cnnEmpData.Open
    
    Set m_rsEmps = New ADODB.Recordset
    With m_rsEmps
        .ActiveConnection = deEmpData.cnnEmpData
        .LockType = adLockOptimistic
        .CursorType = adOpenKeyset
    End With

End Sub

Private Sub Class_Terminate()
    deEmpData.cnnEmpData.Close
    Set m_rsEmps = Nothing
End Sub
